<?php
    header("Content-Type: application/json");
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");

    include_once "../config/bd.php";

    try {
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {

            $course_id = isset($_GET['course_id']) ? intval($_GET['course_id']) : null;

            if (!$course_id) {
                echo json_encode([
                    "success" => false,
                    "message" => "Falta el parámetro course_id"
                ]);
                exit;
            }

            $stmt = $conn->prepare("SELECT * FROM estudiantes WHERE cursos_id_cursos = :course_id");
            $stmt->bindParam(':course_id', $course_id, PDO::PARAM_INT);
            $stmt->execute();

            $students = $stmt->fetchAll(PDO::FETCH_ASSOC);

            echo json_encode([
                "success" => true,
                "students" => $students
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "message" => "Método no permitido"
            ]);
        }
    } catch (PDOException $e) {
        echo json_encode([
            "success" => false,
            "message" => "Error en la base de datos: " . $e->getMessage()
        ]);
    }
?>
